import sqlite3
from urllib.parse  import urlparse, parse_qs
from http.server  import BaseHTTPRequestHandler, HTTPServer

WIDTH, HEIGHT = 50, 20
HOST, PORT = "localhost", 80


class MyHandler(BaseHTTPRequestHandler):
    def start(self):
        return """\
<HTML><BODY>
"""

    def end(self):
        return """\
</BODY></HTML>
"""

    def write_your_name(self):
        return """\
<form action="/go" method="get">
Name: <input type="text" name="name"> <input type="submit" value="Submit"><BR>
</form>
"""

    def world(self):
        strings = [["  " for _ in range(WIDTH)] for _ in range(HEIGHT)]
        for row in self._cursor.execute("""SELECT posx, posy, level FROM players"""):
            strings[row[1]][row[0]] = ("%02d" % row[2])
        strings = ["|"+"".join(string)+"|\n" for string in strings]
        strings.append(("-"*(2*WIDTH+2))+"</pre><BR>")
        strings.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<A HREF="
                       + self._root+"/up?name="+self._name+">Up</A><BR>")
        strings.append("<A HREF="+self._root+"/left?name="+self._name+">Left</A>")
        strings.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<A HREF="
                       + self._root+"/right?name="+self._name+">Right</A><BR>")
        strings.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<A HREF="
                       + self._root+"/down?name="+self._name+">Down</A><BR>")
        return "<pre>"+("-"*(2*WIDTH+2))+"\n"+"".join(strings)

    def _set_headers(self):
        self.send_response(200)
        self.send_header('Content-type', 'text/html')
        self.end_headers()

    def do_GET(self):
        self._connection = sqlite3.connect('game.db')
        self._cursor = self._connection.cursor()
        self._set_headers()

        parsed = urlparse(self.path)
        pquery = parse_qs(parsed.query)
        response = self.start()
        self._root = '..'
        self._name = pquery.get('name', (None,))[0]
        if parsed.path == '/':
            self._root = ''
            response += self.write_your_name()
        if self._name is not None:
            if parsed.path == '/go':
                result = self._cursor.execute("""SELECT name FROM players WHERE name = ?""", (self._name,))
                if result.fetchone() is None:
                    self._cursor.execute("""INSERT INTO players (name, posx, posy, level) VALUES (?, ?, ?, 1)""", (self._name, WIDTH//2, HEIGHT//2))
                response += self.world()
                response += "<BR>I start.<BR>"
                self._connection.commit()
            if parsed.path == '/left':
                self._cursor.execute("""UPDATE players SET posx = posx - 1 WHERE name = ? AND posx > 0""", (self._name,))
                response += self.world()
                response += "<BR>I go left.<BR>"
                self._connection.commit()
            if parsed.path == '/up':
                self._cursor.execute("""UPDATE players SET posy = posy - 1 WHERE name = ? AND posy > 0""", (self._name,))
                response += self.world()
                response += "<BR>I go up.<BR>"
                self._connection.commit()
            if parsed.path == '/down':
                self._cursor.execute("""UPDATE players SET posy = posy + 1 WHERE name = ? AND posy < ?""", (self._name, HEIGHT - 1))
                response += self.world()
                response += "<BR>I go down.<BR>"
                self._connection.commit()
            if parsed.path == '/right':
                self._cursor.execute("""UPDATE players SET posx = posx + 1 WHERE name = ? AND posx < ?""", (self._name, WIDTH - 1))
                response += self.world()
                response += "<BR>I go right.<BR>"
                self._connection.commit()

        response += self.end()
        self._connection.close()
        self.wfile.write(bytes(response, "UTF-8"))


    def do_POST(self):
        self.do_GET()

    def do_HEAD(self):
        self._set_headers()




server = HTTPServer((HOST, PORT), MyHandler)
try:
    server.serve_forever()
except KeyboardInterrupt:
    pass
server.server_close()

